#define AppExeName "Scopy.exe"
#define AppName "Scopy"
#define AppDev "Analog Devices"
#define Python ""
#define DriverVersion "0.8"

[Setup]
AppId={{02A7A7F9-F068-4B1C-85F6-B6D325938E19}
AppName="{#AppName}"
AppVersion="2.0.0"
AppPublisher="Analog Devices, Inc."
AppPublisherURL="http://www.analog.com"
AppSupportURL="http://www.analog.com"
AppUpdatesURL="http://www.analog.com"
AppCopyright="Copyright 2018 Analog Devices, Inc."
CreateAppDir=yes
OutputBaseFilename=scopy-64-setup
LicenseFile="C:\msys64\home\docker\scopy\LICENSE"
OutputDir="C:\Users\AlTrifan\Downloads\to_sign-prealpha\"
AllowNoIcons=yes
Compression=lzma
SolidCompression=yes
ArchitecturesInstallIn64BitMode=x64
DefaultDirName={pf}\{#AppDev}\{#AppName}
DefaultGroupName={#AppName}
AlwaysRestart=yes
DisableDirPage=no
MinVersion=6.2

[Languages]
Name: "english"; MessagesFile: "compiler:Default.isl"
Name: "brazilianportuguese"; MessagesFile: "compiler:Languages\BrazilianPortuguese.isl"
Name: "catalan"; MessagesFile: "compiler:Languages\Catalan.isl"
Name: "corsican"; MessagesFile: "compiler:Languages\Corsican.isl"
Name: "czech"; MessagesFile: "compiler:Languages\Czech.isl"
Name: "danish"; MessagesFile: "compiler:Languages\Danish.isl"
Name: "dutch"; MessagesFile: "compiler:Languages\Dutch.isl"
Name: "finnish"; MessagesFile: "compiler:Languages\Finnish.isl"
Name: "french"; MessagesFile: "compiler:Languages\French.isl"
Name: "german"; MessagesFile: "compiler:Languages\German.isl"
Name: "hebrew"; MessagesFile: "compiler:Languages\Hebrew.isl"
Name: "italian"; MessagesFile: "compiler:Languages\Italian.isl"
Name: "japanese"; MessagesFile: "compiler:Languages\Japanese.isl"
Name: "norwegian"; MessagesFile: "compiler:Languages\Norwegian.isl"
Name: "polish"; MessagesFile: "compiler:Languages\Polish.isl"
Name: "portuguese"; MessagesFile: "compiler:Languages\Portuguese.isl"
Name: "russian"; MessagesFile: "compiler:Languages\Russian.isl"
Name: "slovenian"; MessagesFile: "compiler:Languages\Slovenian.isl"
Name: "spanish"; MessagesFile: "compiler:Languages\Spanish.isl"
Name: "turkish"; MessagesFile: "compiler:Languages\Turkish.isl"
Name: "ukrainian"; MessagesFile: "compiler:Languages\Ukrainian.isl"

[Code]
function isDriverInstalled(): Boolean;
begin
  Result := True;
  if not RegKeyExists(HKLM, 'Software\Analog Devices\{#AppName}\Settings') then
  begin
    Result := False;
  end;
end;

var
  UninstallPage: TNewNotebookPage;
  UninstallButton: TNewButton;
  UninstallDriverCheckBox: TNewCheckBox;

procedure UpdateUninstallWizard;
begin
  if UninstallProgressForm.InnerNotebook.ActivePage = UninstallPage then
  begin
    UninstallProgressForm.PageNameLabel.Caption := 'Uninstall Scopy';
    UninstallProgressForm.PageDescriptionLabel.Caption := '';
  end;
  UninstallButton.Caption := 'Uninstall';
  UninstallButton.ModalResult := mrOK;
end;  

procedure UninstallButtonClick(Sender: TObject);
begin
  UninstallButton.Visible := False;
end;

procedure InitializeUninstallProgressForm();
var
  PageNameLabel: string;
  PageDescriptionLabel: string;
  CancelButtonEnabled: Boolean;
  CancelButtonModalResult: Integer;
  ResultCode : Integer;
  PageCaption: TNewStaticText;
begin
  if not UninstallSilent then
  begin
    { Create the first page and make it active }
    UninstallPage := TNewNotebookPage.Create(UninstallProgressForm);
    UninstallPage.Notebook := UninstallProgressForm.InnerNotebook;
    UninstallPage.Parent := UninstallProgressForm.InnerNotebook;
    UninstallPage.Align := alClient;

    PageCaption := TNewStaticText.Create(UninstallProgressForm);
    PageCaption.Parent := UninstallPage;
    PageCaption.Top := UninstallProgressForm.StatusLabel.Top;
    PageCaption.Left := UninstallProgressForm.StatusLabel.Left;
    PageCaption.Width := UninstallProgressForm.StatusLabel.Width;
    PageCaption.Height := UninstallProgressForm.StatusLabel.Height;
    PageCaption.AutoSize := False;
    PageCaption.ShowAccelChar := False;
    PageCaption.Caption := 'Press Uninstall to proceeed with uninstallation.';

    UninstallDriverCheckBox := TNewCheckBox.Create(UninstallProgressForm);
    UninstallDriverCheckBox.Parent := UninstallPage;
    UninstallDriverCheckBox.Top := PageCaption.Top;
    UninstallDriverCheckBox.Left := PageCaption.Left;
    UninstallDriverCheckBox.Width := PageCaption.Width;
    UninstallDriverCheckBox.Height := PageCaption.Height;
    UninstallDriverCheckBox.Caption := 'Uninstall ADALM2000/ADALM-PLUTO drivers.';
    UninstallProgressForm.InnerNotebook.ActivePage := UninstallPage;

    PageNameLabel := UninstallProgressForm.PageNameLabel.Caption;
    PageDescriptionLabel := UninstallProgressForm.PageDescriptionLabel.Caption;


    UninstallButton := TNewButton.Create(UninstallProgressForm);
    UninstallButton.Parent := UninstallProgressForm;
    UninstallButton.Left :=
      UninstallProgressForm.CancelButton.Left -
      UninstallProgressForm.CancelButton.Width -
      ScaleX(10);
    UninstallButton.Top := UninstallProgressForm.CancelButton.Top;
    UninstallButton.Width := UninstallProgressForm.CancelButton.Width;
    UninstallButton.Height := UninstallProgressForm.CancelButton.Height;
    UninstallButton.OnClick := @UninstallButtonClick;
    UninstallProgressForm.CancelButton.TabOrder := UninstallButton.TabOrder + 1;

    { Run the wizard } 
    UpdateUninstallWizard;
    CancelButtonEnabled := UninstallProgressForm.CancelButton.Enabled
    UninstallProgressForm.CancelButton.Enabled := True;
    CancelButtonModalResult := UninstallProgressForm.CancelButton.ModalResult;
    UninstallProgressForm.CancelButton.ModalResult := mrCancel;

    { Display the First uninstaller page }
    if UninstallProgressForm.ShowModal = mrCancel then Abort;
    
    if UninstallDriverCheckBox.Checked = True then
    begin
        if not Exec(ExpandConstant('{app}\drivers\dpinst.exe'), '/s /U pluto-cdc-acm.inf', ExpandConstant('{app}\drivers'), SW_SHOW, ewWaitUntilTerminated, ResultCode) then
        begin
           MsgBox('Failed to uninstall drivers: ' +  SysErrorMessage(ResultCode) + '.', mbInformation, MB_OK);
        end;

        if not Exec(ExpandConstant('{app}\drivers\dpinst.exe'), '/s /U pluto-rndis.inf', ExpandConstant('{app}\drivers'), SW_SHOW, ewWaitUntilTerminated, ResultCode) then
        begin
           MsgBox('Failed to uninstall drivers: ' +  SysErrorMessage(ResultCode) + '.', mbInformation, MB_OK);
        end;

        if not Exec(ExpandConstant('{app}\drivers\dpinst.exe'), '/s /U pluto-usbd.inf', ExpandConstant('{app}\drivers'), SW_SHOW, ewWaitUntilTerminated, ResultCode) then
        begin
           MsgBox('Failed to uninstall drivers: ' +  SysErrorMessage(ResultCode) + '.', mbInformation, MB_OK);
        end;

        if not Exec(ExpandConstant('{app}\drivers\dpinst.exe'), '/s /U pluto-dfu.inf', ExpandConstant('{app}\drivers'), SW_SHOW, ewWaitUntilTerminated, ResultCode) then
        begin
           MsgBox('Failed to uninstall drivers: ' +  SysErrorMessage(ResultCode) + '.', mbInformation, MB_OK);
        end;

        if not RegDeleteKeyIncludingSubkeys(HKEY_LOCAL_MACHINE, 'Software\Analog Devices\Scopy') then
        begin
           MsgBox('Failed to remove registry key: Scopy.', mbInformation, MB_OK);
        end;
    end;
    UninstallProgressForm.CancelButton.Enabled := CancelButtonEnabled;
    UninstallProgressForm.CancelButton.ModalResult := CancelButtonModalResult;
    UninstallProgressForm.PageNameLabel.Caption := PageNameLabel;
    UninstallProgressForm.PageDescriptionLabel.Caption := PageDescriptionLabel;
    UninstallProgressForm.InnerNotebook.ActivePage := UninstallProgressForm.InstallingPage;
  end;
end;


function GetInstallLocation(): String;
var
  regPath: String;
  installLocationString: String;
begin
  regPath := ExpandConstant('Software\Microsoft\Windows\CurrentVersion\Uninstall\{#SetupSetting("AppId")}_is1');
  installLocationString := '';
  if not RegQueryStringValue(HKLM, regPath, 'InstallLocation', installLocationString) then
    RegQueryStringValue(HKCU, regPath, 'InstallLocation', installLocationString);
  Result := installLocationString;
end;

function GetUninstallerString(): String;
var
  regPath: String;
  uninstallerString: String;
begin
  regPath := ExpandConstant('Software\Microsoft\Windows\CurrentVersion\Uninstall\{#SetupSetting("AppId")}_is1');
  uninstallerString := '';
  if not RegQueryStringValue(HKLM, regPath, 'UninstallString', uninstallerString) then
    RegQueryStringValue(HKCU, regPath, 'UninstallString', uninstallerString);
  Result := uninstallerString;
end;


function IsUpgrade(): Boolean;
begin
  Result := (GetInstallLocation() = ExpandConstant('{app}\'));
end;


procedure RemoveOldVersion();
var
  installLocationString: String;
  uninstallerString: String;
  resultCode: Integer;
begin
  installLocationString := GetInstallLocation();
  uninstallerString := GetUninstallerString();
  if installLocationString <> '' then begin
    uninstallerString := RemoveQuotes(uninstallerString);
    if not Exec(uninstallerString, '/SILENT /NORESTART /SUPPRESSMSGBOXES','', SW_HIDE, ewWaitUntilTerminated, resultCode) then
    begin
      MsgBox('Failed to uninstall previous version!', mbInformation, MB_OK);
    end;
  end;
end;

procedure CurStepChanged(CurStep: TSetupStep);
begin
  if (CurStep=ssInstall) then
  begin
    if (isUpgrade()) then
    begin
      if MsgBox('A different Scopy version was found at this location. Remove before installing?', mbConfirmation, MB_YESNO or MB_DEFBUTTON2) = IDYES then
      begin
        RemoveOldVersion();
      end;
    end;
  end;
end;


[Tasks]
Name: "desktopicon"; Description: "{cm:CreateDesktopIcon}"; GroupDescription: "{cm:AdditionalIcons}"
Name: "deleteini"; Description: Delete previous settings (Scopy.ini)
Name: "deletepreferences"; Description: Delete previous application preferences (Preferences.ini)
Name: "drivers"; Description: Install drivers for ADALM2000; Check: not isDriverInstalled;
Name: "drivers_overwrite"; Description: Install drivers for ADALM2000; Check: isDriverInstalled; Flags: unchecked

[Files]
Source: "C:\Users\AlTrifan\Downloads\scopy-prealpha-windows-portable\scopy-prealpha-windows-portable\scopy-windows-x86_64-f38aabe\*"; DestDir: "{app}"; Check: Is64BitInstallMode; Flags: ignoreversion recursesubdirs createallsubdirs

[Icons]
Name: "{group}\{#AppName}"; Filename: "{app}\{#AppExeName}"
Name: "{group}\{cm:UninstallProgram,{#AppName}}"; Filename: "{uninstallexe}"
Name: "{commondesktop}\{#AppName}"; Filename: "{app}\{#AppExeName}"; Tasks: desktopicon

[InstallDelete]
Type: files; Name: "{userappdata}\ADI\Scopy.ini"; Tasks: deleteini
Type: files; Name: "{userappdata}\ADI\Preferences.ini"; Tasks: deletepreferences

[Run]
Filename: "{app}\drivers\dpinst.exe"; Parameters: "/PATH ""{app}\drivers"" {param:dpinstflags|/F}" ; Flags: waituntilterminated; Tasks: drivers drivers_overwrite

[Registry]
Root: HKLM; Subkey: "Software\Analog Devices"
Root: HKLM; Subkey: "Software\Analog Devices\{#AppName}"
Root: HKLM; Subkey: "Software\Analog Devices\{#AppName}\Settings"; ValueType: string; ValueName: "InstallPath"; ValueData: "{app}"
Root: HKLM; Subkey: "Software\Analog Devices\{#AppName}\Settings"; ValueType: string; ValueName: "InstallVersion"; ValueData: {#DriverVersion}
